const passwordInput = document.getElementById("password");
const strengthMeterFill = document.getElementById("strength-meter-fill");
const strengthText = document.getElementById("strength-text");

passwordInput.addEventListener("input", function() {
    const password = passwordInput.value;
    const strength = calculateStrength(password);
    updateStrengthMeter(strength);
});

function calculateStrength(password) {
    let strength = 0;
    if (password.length >= 8) {
        strength += 1;
    }
    if (/[a-z]/.test(password)) {
        strength += 1;
    }
    if (/[A-Z]/.test(password)) {
        strength += 1;
    }
    if (/\d/.test(password)) {
        strength += 1;
    }
    if (/[!@#$%^&*(),.?":{}|<>]/.test(password)) {
        strength += 1;
    }
    return strength;
}

function updateStrengthMeter(strength) {
    const fillPercentage = (strength / 5) * 100;
    strengthMeterFill.style.width = fillPercentage + "%";

    switch (strength) {
        case 0:
        case 1:
            strengthText.textContent = "Strength: Very Weak";
            break;
        case 2:
            strengthText.textContent = "Strength: weak";
            break;
        case 3:
            strengthText.textContent = "Strength: Medium";
            break;
        case 4:
            strengthText.textContent = "Strength: Strong";
            break;
        case 5:
            strengthText.textContent = "Strength: Very Strong";
            break;
        case 6:
            strengthText.textContent = "Strength: Unknow";
            break;                    
    }
}